using System;

namespace InterfaceDemo
{
	interface IStorable
	{
		void Read();
		void Write(object obj);
		int Status { get; set; }
	}

	public class Document : IStorable
	{
		// Przechowuje warto wymaganej waciwoci interfejsu IStorable
		private int status = 0;

		public Document(string s)
		{
			Console.WriteLine("Tworzenie dokumentu: {0}", s);
		}

		#region IStorable

		public void Read()
		{
			Console.WriteLine(
			"Implementacja metody Read interfejsu IStorable");
		}

		public void Write(object o)
		{
			Console.WriteLine(
			"Implementacja metody Write interfejsu IStorable");
		}

		public int Status
		{
			get { return status; }
			set { status = value; }
		}
		#endregion

	}

	class Tester
	{
		public void Run()
		{
			Document doc = new Document("Dokument testowy");
			doc.Status = -1;
			doc.Read();
			Console.WriteLine("Status dokumentu: {0}", doc.Status);
		}

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}
